using System;
using System.Text;
using System.Linq;

public class Program
{
    static void ReadDimensions(ref long n, ref long m, ref long k, ref long l, string str, StringBuilder sb)
    {
        int counter = 0;
        foreach(char c in str)
        {
            if (c!=' ') sb.Append(c);
            else
            {
              switch(counter)
              {
                case 0:
                  n = int.Parse(sb.ToString());
                  break;
                case 1:
                  m = int.Parse(sb.ToString());
                  break;
                case 2:
                  k = int.Parse(sb.ToString());
                  break;
                default:
                  break;
              }
              counter++;
              sb.Clear(); 
            }
        }
        l = int.Parse(sb.ToString());
        sb.Clear();
    }
    
    static void ReadValues(ref long[] vals, string str, StringBuilder sb)
    {
      int counter = 0;
      foreach(char c in str)
      {
        if (c!=' ') sb.Append(c);
        else
        {
          vals[counter] = int.Parse(sb.ToString());
          counter++;
          sb.Clear();
        }
      }
      vals[counter] = int.Parse(sb.ToString());
      sb.Clear();
    }
    
    static void MostCommonCoords(long[,] matrix,long n, long m, long k, long l)
    {
      long vertCount = m-l+1;
      long horCount = n-k+1;
      
      for(long x = 0; x<horCount;x++)
      {
        for(long y = 0; y<vertCount;y++)
        {
          for(long i=0;i<k;i++)
          {
            for(long j=0;j<l;j++)
            { 
              if(j+y>m) break;
              matrix[i+x,j+y]++;
            }
            if(i+x>n) break;
          }
        }
      }
    }
    
    static void SortArray(ref long[] array, int leftIndex, int rightIndex)
    {
        var i = leftIndex;
        var j = rightIndex;
        var pivot = array[leftIndex];
        while (i <= j)
        {
            while (array[i] > pivot)
            {
                i++;
            }
            
            while (array[j] < pivot)
            {
                j--;
            }
            if (i <= j)
            {
                long temp = array[i];
                array[i] = array[j];
                array[j] = temp;
                i++;
                j--;
            }
        }
        
        if (leftIndex < j)
            SortArray(ref array, leftIndex, j);
        if (i < rightIndex)
            SortArray(ref array, i, rightIndex);
    }
    
    static void SumOfSubmatrixSums(long[,] matrix, long n, long m, long k, long l)
    {
      long vertCount = m-l+1;
      long horCount = n-k+1;
      long sum = 0;
      for(long x = 0; x<horCount;x++)
      {
        for(long y = 0; y<vertCount;y++)
        {
          for(long i=0;i<k;i++)
          {
            for(long j=0;j<l;j++)
            { 
              if(j+y>m) break;
              sum += matrix[i+x,j+y];
            }
            if(i+x>n) break;
          }
        }
      }
      Console.WriteLine(sum);
    }
    
    static void Main(string[] args)
    {
        long n = 0, m = 0, k = 0, l = 0;
        StringBuilder sb = new StringBuilder();
        
        string dim = Console.ReadLine();
        string val = Console.ReadLine();
        
        ReadDimensions(ref n,ref m,ref k,ref l,dim,sb);
        
        long[] vals = new long[n*m];
        ReadValues(ref vals, val, sb);
        SortArray(ref vals, 0, vals.Length-1);
        
        long[,] matrix = new long[n,m];
        bool[,] wasChanged = new bool[n,m];
        for(int i = 0; i<n; i++)
        {
          for(int j = 0; j<m; j++)
          {
            wasChanged[i,j] = false;
          }
        }
        MostCommonCoords(matrix,n,m,k,l);
        
        
        
        var max = (from long num in matrix select num).Max();
        long indexOfVal = 0;
        for(long h = max; h>0; h--)
        {
          for(long i = 0; i<n; i++)
          {
            for(long j = 0; j<m; j++)
            {
              if(matrix[i,j] == h && indexOfVal<n*m && wasChanged[i,j] == false)
              {
                matrix[i,j] = vals[indexOfVal];
                wasChanged[i,j] = true;
                indexOfVal++;
              }
            }
          }
        }
        SumOfSubmatrixSums(matrix,n,m,k,l);
    }
}